/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/
#include "SurfaceSetIpAcceptanceCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"

ExecutionResult SurfaceSetIpAcceptanceCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());
    SeatList removeList;
    RendererListConstIterator it;
    SeatList::iterator seat_it;
    RendererList *rList = executor->getRendererList();

    ExecutionResult result = ExecutionFailed;

    Surface* surface = scene.getSurface(m_idtoSet);

    if (surface)
    {
        LOG_DEBUG("SurfaceSetIpAcceptanceCommand",
                  "Setting input acceptance for" << m_sizeSeatArray << " seats");

        /*Get list of seats from which this surface stops accepting inputs now onwards
         * because of new seat list*/
        surface->getRemoveSeatList(&removeList, m_pSeatArray, m_sizeSeatArray);
        for (seat_it = removeList.begin(); seat_it != removeList.end(); seat_it++)
        {
            for (it = rList->begin(); it != rList->end(); ++it)
            {
                InputManager* pInputManager = (*it)->getInputManager((char*)(*seat_it)->c_str());
                if (NULL != pInputManager)
                {
                    pInputManager->dropFocuses(m_idtoSet);
                }
            }
        }
        if (surface->setAcceptedSeats(m_pSeatArray, m_sizeSeatArray))
        {
            result = ExecutionSuccess;
        }
    }

    return result;
}

const std::string SurfaceSetIpAcceptanceCommand::getString()
{
    std::stringstream description;
    description << "SurfaceSetIpAcceptanceCommand("
                << "idtoSet=" << m_idtoSet << "(0x" << std::hex << m_idtoSet << ")" << std::dec
                << ", number of seats=" << m_sizeSeatArray
                << ")";
    return description.str();
}
